/*
 * mqtt_network_Manager.h
 *
 *  Created on: Oct 21, 2018
 *      Author: gjd5kor
 */

#ifndef APPL_NETWORKMANAGER_MQTT_NETWORK_MANAGER_H_
#define APPL_NETWORKMANAGER_MQTT_NETWORK_MANAGER_H_


#define WITH_THREADING

#include "Imqtt_network_Manager.h"
#include "asf/core/Timer.h"
#include "mqtt_MosquittoCpp_Wrapper.h"
#include "mqtt_Class_Types.h"

using namespace::asf::core;

class mqtt_network_Manager
		: public mqtt_MosquittoCppWrapper,
		  public TimerCallbackIF,
		  public I_mqtt_network_Manager
{

public:
	virtual ~mqtt_network_Manager();
	mqtt_network_Manager(mqtt_manager_tclAppMain *_poMainAppl,std::string &sNaviId,bool CS,bool _CompressionMode);

	virtual void vHandleMessage(mqtt_manager_tclBaseIf::TMsg* pMsg){(void)pMsg;};
	virtual void vHandleTraceMessage(const tUChar* puchData) {};
	virtual void vGetReferences() {};
	virtual void vStartCommunication() {};
	virtual void vTraceInfo(){};
	virtual const tChar* getName() const { return "mqtt_network_Manager"; };

	bool Initialize(std::string &sNaviId,bool CS,bool CompressionMode);
	int Connect(std::string &sUrl, unsigned port, unsigned short keepAlive, unsigned short ConAckTimeOut);
	int Publish(std::string &sTopic, std::string &sMsg, int &Mid, unsigned short Interval,unsigned short PubAckTimeout,unsigned short Occurence);
	int Subscribe(std::string &sTopic,unsigned short SubAckTimeout,int &Mid);
	int Reinitialize(bool Cleansession);
	int Disconnect();
	int RetryPublish();
	void SetIpServiceAvailability(bool bIpServiceStatus);
	virtual int ReConnect(std::string &sUrl, unsigned port, unsigned short keepAlive, unsigned short ConAckTimeOut);


	//Time Expiry Callback
	virtual void onExpired(Timer& timer, ::boost::shared_ptr< TimerPayload > data);

	//Mosquittocpp Callback
	virtual void on_connect(int rc);
	virtual void on_connect_with_flags(int rc, int flags);
	virtual void on_disconnect(int rc) ;
	virtual void on_publish(int mid) ;
	virtual void on_message(const struct mosquitto_message * message);
	virtual void on_subscribe(int mid, int qos_count, const int * granted_qos);
	virtual void on_unsubscribe(int mid);
	virtual void on_log(int  level, const char * str) ;
	virtual void on_error();



private:

	enum Disconnection_Reason
	{
		UNKNOWN = 0,
		EXTRANAL,
		SUBSCRIBE_FAIL,
		PUBLISH_FAIL,
		CONACK_FAIL
	};

	//Member Variables
	std::string sNaviUnitId;
	bool NetworkLoopActive;
	bool Connected;
	bool Initialized;


	Timer oPubACKTimer;
	Timer oConACKTimer;
	Timer oSubAckTimer;
	Timer oPendingItemUploadTimer;

	//Data
	bool Compression_State;
	bool bIpServiceAvaibility;

	Timer oPublishIntervalTimer;

	unsigned short Publish_Interval;
	unsigned short Publish_Occurence;
	unsigned short Publish_Timeout;
	unsigned short Remaining_Retry_Attempts;
	bool bReconnectedDueToPublishFail;
	unsigned short keepaliveval;

	unsigned short DisconnectionReason;

	std::vector<tTLS_Error_String> oTLS_Error_List;


private:
	void ActionOnCONACKTimerExpired();
	void ActionOnPUBACKTimerExpired();
	void ActionOnSUBACKTimerExpired();
	void ActionOnPUBINTimerExpired();
	void ActionOnDisconnectionResponse(int response_code);
	bool bIsTLSFatalError();
	void SendResponse(MqttNetworkResponse *Response);
	void LoadTLSErrorList();
	bool ConnectionPreCheck(int &connection_response);
	void stop_loop(bool force);
	void InternalDisconnect();
	void UpdateDisconnectionReasonToMqttLogFile(std::string &sLogMsg,int serverresonsecode);
	void AdditionalStepsOnDisconnection(unsigned ConnectionResponseCode);
	void PublishRetryOnConnection();

};

#endif /* APPL_NETWORKMANAGER_MQTT_NETWORK_MANAGER_H_ */
